/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __NB_NOTELIST_H__
#define __NB_NOTELIST_H__

#include <glib.h>

#include "nb_note.h"

typedef struct _notelist notelist;

enum {
	ADD_NOTE,
	DEL_NOTE,
	UPDATE_NOTE,
};

struct _notelist
{
	gchar * filename;
	GPtrArray * notes;
};

notelist	* nb_notelist_new	(const gchar * filename);

void	nb_notelist_add		(notelist * nl, note * n);

void 	nb_notelist_remove	(notelist * nl, note * n);

void 	nb_notelist_free	(notelist * nl);

gboolean	nb_notelist_load_from_file	(notelist * nl);

int	nb_notelist_get_note_index (notelist * nl, note * n);

gchar 	* nb_notelist_get_text_from_index (notelist * nl, int index);

gboolean	nb_notelist_update_file (notelist * nl, note * n, int action);

#endif
